<?php if (!defined('_GNUBOARD_')) exit;

function getProfileLink($mb_id) {
    $currentDomain = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
    return $currentDomain . "/bbs/profile.php?mb_id=" . $mb_id;
}

function getFacebookShareLink($u) { return "https://www.facebook.com/sharer.php?u=" . urlencode($u); }
function getTwitterShareLink($u) { return "https://twitter.com/intent/tweet?url=" . urlencode($u); }
function getLineShareLink($u, $m) { return "https://social-plugins.line.me/lineit/share?url=" . urlencode($u) . "&text=" . urlencode($m); }

function getPluginImagePath() {
    $p = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://";
    $h = $_SERVER['HTTP_HOST'];
    $o = $_SERVER['SERVER_PORT'];
    $s = ($o !== 80 && $o !== 443) ? ":" . $o : "";
    $u = $p . $h . $s . "/plugin/sns_share/img";
    return $u;
}

$pi = getPluginImagePath();
$profileLink = getProfileLink($mb_id);
$fs = getFacebookShareLink($profileLink);
$ts = getTwitterShareLink($profileLink);
$ls = getLineShareLink($profileLink, "라인으로 공유합니다!");
?>

<div id='sns' style="display: flex; justify-content: center;">
    <a href="javascript:void(0);" id="copyLink" style="margin-right: 10px;">
        <img src="<?= $pi ?>/url.webp" alt="프로필 링크" width='50px' height='auto'/>
    </a>

    <a href="<?= $ls ?>" target="_blank" style="margin-right: 10px;">
        <img src="<?= $pi ?>/line.webp" alt="라인 공유" width='50px' height='auto'/>
    </a>
    <a href="<?= $fs ?>" target="_blank" style="margin-right: 10px;">
        <img src="<?= $pi ?>/meta.webp" alt="페이스북 공유" width='50px' height='auto'/> <!-- }safari에서는 많은 리다이렉트로 작동 안됨 -->
    </a>
    <a href="<?= $ts ?>" target="_blank">
        <img src="<?= $pi ?>/x.webp" alt="트위터 공유" width='50px' height='auto'/>
    </a>
</div>

<script>
document.getElementById('copyLink').addEventListener('click', function() {
    copyToClipboard("<?php echo $profileLink; ?>");
    showCopyNotification();
});

function copyToClipboard(text) {
    navigator.clipboard.writeText(text);
}

function showCopyNotification() {
    // 복사 알림 요소 생성
    const copyNotification = document.createElement('div');
    copyNotification.classList.add('copy-notification');

    // 복사 아이콘 생성
    const copyIcon = document.createElement('i');
    copyIcon.classList.add('fa', 'fa-check-circle');
    copyNotification.appendChild(copyIcon);

    // 복사 메시지 생성
    const copyMessage = document.createElement('span');
    copyMessage.textContent = ' 프로필 URL이 복사되었습니다.';
    copyNotification.appendChild(copyMessage);

    // 화면에 추가
    document.body.appendChild(copyNotification);

    // 2초 후에 숨기기
    setTimeout(() => {
        copyNotification.classList.add('hide');
        setTimeout(() => {
            document.body.removeChild(copyNotification);
        }, 500); // 애니메이션 시간
    }, 2500);
}
</script>
<style>
.copy-notification {
    position: fixed;
    top: 20px;
    left: 50%;
    transform: translateX(-50%);
    background-color: #333;
    color: #fff;
    padding: 10px 20px;
    border-radius: 4px;
    box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    display: flex;
    align-items: center;
    opacity: 1;
    transition: opacity 0.5s ease;
    z-index:2;
    top:70px
}

.copy-notification .fa {
    margin-right: 10px;
    font-size: 16px;
    color:green
}

.copy-notification.hide {
    opacity: 0;
}
</style>